/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.custinfo;

import com.ibm.hwmca.base.custinfo.CustomerInfoConstants;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SystemBean
extends PanelBean
implements CustomerInfoConstants {
    private static final String TRACE_MASKT = "XSETSYBT";
    private static final String TRACE_MASKF = "XSETSYBF";
    private static final String TRACE_MASKD = "XSETSYBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "SysInfoBean");
    private List availCountries;
    private String countryCode = "";
    private Map availSubdivisions;
    private String subdivisionCode = "";
    private boolean m_bUseAdminMailingAddress;
    private String m_sStreetAddress;
    private String m_sStreetAddress2;
    private String m_sCityLocality;
    private String m_sCountryRegion;
    private transient ValueDescriptor[] m_vdCountryRegion;
    private String m_sStateProvince;
    private transient ValueDescriptor[] m_vdStateProvince;
    private String m_sPostalCode;
    private String m_sModemNumber;

    public SystemBean() {
        Trace.trace(TRACE_MASKT, "<> SystemBean()");
    }

    public void setUseAdminMailingAddress(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setUseAdminMailingAddress(" + b + ")");
        this.m_bUseAdminMailingAddress = b;
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setUseAdminMailingAddress()");
    }

    public boolean isUseAdminMailingAddress() {
        Trace.trace(TRACE_MASKT, "<> getUseAdminMailingAddress() " + this.m_bUseAdminMailingAddress);
        return this.m_bUseAdminMailingAddress;
    }

    public void setStreetAddress(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setStreetAddress(" + s + ")");
        this.m_sStreetAddress = s;
        Trace.trace(TRACE_MASKT, "<- setStreetAddress()");
    }

    public String getStreetAddress() {
        Trace.trace(TRACE_MASKT, "<> getStreetAddress() " + this.m_sStreetAddress);
        return this.m_sStreetAddress;
    }

    public void setStreetAddress2(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setStreetAddress2(" + s + ")");
        this.m_sStreetAddress2 = s;
        Trace.trace(TRACE_MASKT, "<- setStreetAddress2()");
    }

    public String getStreetAddress2() {
        Trace.trace(TRACE_MASKT, "<> getStreetAddress2() " + this.m_sStreetAddress2);
        return this.m_sStreetAddress2;
    }

    public void setCityLocality(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setCityLocality(" + s + ")");
        this.m_sCityLocality = s;
        Trace.trace(TRACE_MASKT, "<- setCityLocality()");
    }

    public String getCityLocality() {
        Trace.trace(TRACE_MASKT, "<> getCityLocality() " + this.m_sCityLocality);
        return this.m_sCityLocality;
    }

    public ValueDescriptor[] getCountryRegionList() {
        Trace.trace(TRACE_MASKT, "<> getCountryRegionList() " + this.m_vdCountryRegion.length);
        return this.m_vdCountryRegion;
    }

    public void setCountryRegion(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setCountryRegion(" + s + ")");
        this.m_sCountryRegion = s;
        this.countryCode = this.getCountryCode(s);
        this.subdivisionCode = "";
        this.updateDataBeanInfo(false);
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- setCountryRegion()");
    }

    public String getCountryRegion() {
        Trace.trace(TRACE_MASKT, "<> getCountryRegion() " + this.m_sCountryRegion);
        return this.m_sCountryRegion;
    }

    public ValueDescriptor[] getStateProvinceList() {
        Trace.trace(TRACE_MASKT, "<> getStateProvinceList() " + this.m_vdStateProvince.length);
        return this.m_vdStateProvince;
    }

    public void setStateProvince(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setStateProvince(" + s + ")");
        this.m_sStateProvince = s;
        this.subdivisionCode = this.getSubdivisionCode(this.countryCode, s);
        Trace.trace(TRACE_MASKT, "<- setStateProvince()");
    }

    public String getStateProvince() {
        Trace.trace(TRACE_MASKT, "<> getStateProvince() " + this.m_sStateProvince);
        return this.m_sStateProvince;
    }

    public void setPostalCode(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setPostalCode(" + s + ")");
        this.m_sPostalCode = s;
        Trace.trace(TRACE_MASKT, "<- setPostalCode()");
    }

    public String getPostalCode() {
        Trace.trace(TRACE_MASKT, "<> getPostalCode() " + this.m_sPostalCode);
        return this.m_sPostalCode;
    }

    public void setModemNumber(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> setModemNumber(" + s + ")");
        this.m_sModemNumber = s;
        Trace.trace(TRACE_MASKT, "<- setModemNumber()");
    }

    public String getModemNumber() {
        Trace.trace(TRACE_MASKT, "<> getModemNumber() " + this.m_sModemNumber);
        return this.m_sModemNumber;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        this.m_vdCountryRegion = new ValueDescriptor[0];
        this.m_vdStateProvince = new ValueDescriptor[0];
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setAvailCountries(List countries) {
        Trace.trace(TRACE_MASKT, "-> setAvailCountries(" + countries.size() + ")");
        this.availCountries = countries;
        Trace.trace(TRACE_MASKT, "<- setAvailCountries()");
    }

    public void setCountryCode(String isoCode) {
        Trace.trace(TRACE_MASKT, "-> setCountryCode(" + isoCode + ")");
        this.countryCode = isoCode;
        Trace.trace(TRACE_MASKT, "<- setCountryCode()");
    }

    public String getCountryCode() {
        Trace.trace(TRACE_MASKT, "<> getCountryCode() " + this.countryCode);
        return this.countryCode;
    }

    public void setAvailSubdivisions(Map subdivisions) {
        Trace.trace(TRACE_MASKT, "-> setAvailSubdivisions(" + subdivisions.size() + ")");
        this.availSubdivisions = subdivisions;
        Trace.trace(TRACE_MASKT, "<- setAvailSubdivisions()");
    }

    public void setSubdivisionCode(String isoCode) {
        Trace.trace(TRACE_MASKT, "-> setSubdivisionCode(" + isoCode + ")");
        this.subdivisionCode = isoCode;
        Trace.trace(TRACE_MASKT, "<- setSubdivisionCode()");
    }

    public String getSubdivisionCode() {
        Trace.trace(TRACE_MASKT, "<> getSubdivisionCode() " + this.subdivisionCode);
        return this.subdivisionCode;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
        try {
            String element = event.getElementName();
            Trace.trace(TRACE_MASKF, "Unknown element");
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 2069, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        Trace.trace(TRACE_MASKT, "-> parentalAction(" + event + ")");
        try {
            String command = event.getActionCommand();
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else if (command.endsWith("ParentalCommit")) {
                try {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("SystemBean");
                    request.setData("Source", "SystemPanel");
                    request.setData("Command", "Commit");
                    request.setData("Bean", this);
                    this.postTaskletRequest(request);
                }
                catch (IllegalUserDataException iude) {}
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 2069, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- parentalAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> update()");
        try {
            HashMap data = (HashMap)newData;
            String command = (String)data.get("Command");
            if (command == null) {
                command = "";
            }
            Trace.trace(TRACE_MASKF, "command=" + command);
            if (command.equals("")) {
                Trace.trace(TRACE_MASKF, "Unspecified command");
            } else {
                Trace.trace(TRACE_MASKF, "Unknown command");
            }
        }
        catch (RuntimeException rte) {
            new FrameworkLog(classLogInfo, 2069, rte).log();
        }
        Trace.trace(TRACE_MASKT, "<- update()");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        if (initialUpdate) {
            int numOfCountries = this.availCountries.size();
            if (numOfCountries > 0) {
                this.m_vdCountryRegion = new ValueDescriptor[numOfCountries];
                int i = 0;
                while (i < numOfCountries) {
                    String desc = ((DisplayableCountry)this.availCountries.get(i)).getDescription();
                    this.m_vdCountryRegion[i] = new ValueDescriptor(null, desc);
                    ++i;
                }
                if (this.countryCode.equals("")) {
                    DisplayableCountry country = this.getDefaultCountry();
                    this.countryCode = country.getIsoCode();
                    this.m_sCountryRegion = country.getDescription();
                } else {
                    this.m_sCountryRegion = this.getCountryDesc(this.countryCode);
                }
            } else {
                this.countryCode = "";
                this.m_vdCountryRegion = new ValueDescriptor[0];
                this.m_sCountryRegion = "";
            }
        }
        if (this.availSubdivisions.containsKey(this.countryCode)) {
            List subdivisions = (List)this.availSubdivisions.get(this.countryCode);
            int numOfSubdivisions = subdivisions.size();
            this.m_vdStateProvince = new ValueDescriptor[numOfSubdivisions];
            int i = 0;
            while (i < numOfSubdivisions) {
                String desc = ((DisplayableSubdivision)subdivisions.get(i)).getDescription();
                this.m_vdStateProvince[i] = new ValueDescriptor(null, desc);
                ++i;
            }
            if (this.subdivisionCode.equals("")) {
                DisplayableSubdivision subdivision = (DisplayableSubdivision)subdivisions.get(0);
                this.subdivisionCode = subdivision.getIsoCode();
                this.m_sStateProvince = subdivision.getDescription();
            } else {
                this.m_sStateProvince = this.getSubdivisionDesc(this.countryCode, this.subdivisionCode);
            }
        } else {
            this.subdivisionCode = "";
            this.m_vdStateProvince = new ValueDescriptor[0];
            this.m_sStateProvince = "";
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            if (this.m_bUseAdminMailingAddress) {
                this.userTaskManager.setEnabled(prefix + "StreetAddress", false);
                this.userTaskManager.setEnabled(prefix + "StreetAddress2", false);
                this.userTaskManager.setEnabled(prefix + "CityLocality", false);
                this.userTaskManager.setEnabled(prefix + "CountryRegion", false);
                this.userTaskManager.setEnabled(prefix + "StateProvince", false);
                this.userTaskManager.setEnabled(prefix + "PostalCode", false);
            } else {
                this.userTaskManager.setEnabled(prefix + "StreetAddress", true);
                this.userTaskManager.setEnabled(prefix + "StreetAddress2", true);
                this.userTaskManager.setEnabled(prefix + "CityLocality", true);
                this.userTaskManager.setEnabled(prefix + "CountryRegion", true);
                if (this.availSubdivisions.containsKey(this.countryCode)) {
                    this.userTaskManager.setEnabled(prefix + "StateProvince", true);
                } else {
                    this.userTaskManager.setEnabled(prefix + "StateProvince", false);
                }
                this.userTaskManager.setEnabled(prefix + "PostalCode", true);
            }
            this.userTaskManager.refreshElement(prefix + "StreetAddress");
            this.userTaskManager.refreshElement(prefix + "StreetAddress2");
            this.userTaskManager.refreshElement(prefix + "CityLocality");
            this.userTaskManager.refreshElement(prefix + "CountryRegion");
            this.userTaskManager.refreshElement(prefix + "StateProvince");
            this.userTaskManager.refreshElement(prefix + "PostalCode");
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }

    private String getCountryCode(String desc) {
        String countryCode = "";
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry country = (DisplayableCountry)iterator.next();
            if (!country.getDescription().equals(desc)) continue;
            countryCode = country.getIsoCode();
            break;
        }
        return countryCode;
    }

    private String getCountryDesc(String isoCode) {
        String countryDesc = "";
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry country = (DisplayableCountry)iterator.next();
            if (!country.getIsoCode().equals(isoCode)) continue;
            countryDesc = country.getDescription();
            break;
        }
        return countryDesc;
    }

    private String getSubdivisionCode(String isoCtryCode, String desc) {
        String subdivisionCode = "";
        if (this.availSubdivisions.containsKey(isoCtryCode)) {
            List subdivisions = (List)this.availSubdivisions.get(isoCtryCode);
            Iterator iterator = subdivisions.iterator();
            while (iterator.hasNext()) {
                DisplayableSubdivision subdivision = (DisplayableSubdivision)iterator.next();
                if (!subdivision.getDescription().equals(desc)) continue;
                subdivisionCode = subdivision.getIsoCode();
                break;
            }
        }
        return subdivisionCode;
    }

    private String getSubdivisionDesc(String isoCtryCode, String isoSubCode) {
        String subdivisionDesc = "";
        if (this.availSubdivisions.containsKey(isoCtryCode)) {
            List subdivisions = (List)this.availSubdivisions.get(isoCtryCode);
            Iterator iterator = subdivisions.iterator();
            while (iterator.hasNext()) {
                DisplayableSubdivision subdivision = (DisplayableSubdivision)iterator.next();
                if (!subdivision.getIsoCode().equals(isoSubCode)) continue;
                subdivisionDesc = subdivision.getDescription();
                break;
            }
        }
        return subdivisionDesc;
    }

    private DisplayableCountry getDefaultCountry() {
        DisplayableCountry defaultCountry = null;
        Locale locale = Locale.getDefault();
        String clientCountryCode = locale.getCountry();
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry country = (DisplayableCountry)iterator.next();
            if (!country.getIsoCode().equals(clientCountryCode)) continue;
            defaultCountry = country;
            break;
        }
        if (defaultCountry == null && this.availCountries.size() > 0 && this.availCountries.size() > 0) {
            defaultCountry = (DisplayableCountry)this.availCountries.get(0);
        }
        return defaultCountry;
    }
}

